<x-app-layout>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">

            <div class="flex flex-col lg:flex-row gap-6 lg:gap-12 px-6 lg:px-0 mb-12">
                <img src="{{ url('/theme/' . $theme->code . '/sneak_view.jpg') }}"
                    class="w-full rounded-xl shadow max-w-md">
                <div class="lg:flex-grow flex flex-col">
                    <h1 class="font-bold text-2xl lg:text-6xl">{{ $theme->name }}</h1>
                    <h4 class="font-semibold text-lg">Category / {{ $theme->category }}</h4>
                    <div class="flex-grow flex flex-col justify-center py-6">
                        {{-- <p class="text-xs">Harga Asal</p>
                        <h4 class="text-2xl"><span class="font-bold line-through text-red-700 text-4xl">RM 116</span>
                            75% OFF!</h4>
                        <p class="text-xs">Sekarang Hanya</p>
                        <h4 class="text-2xl font-bold text-green-700">RM 29</h4> --}}
                        <div class="grid grid-cols-1 gap-2">
                            @php
                                $lastday = date('Y-m-t', strtotime(NOW()));
                                $lastdate = date('d F', strtotime($lastday));
                                $originalstart = date('d F', strtotime($lastday . ' +1 day'));

                                $currentDate = new DateTime();
                                $lastDayOfMonth = new DateTime($currentDate->format('Y-m-t'));
                                $daysRemaining = $currentDate->diff($lastDayOfMonth)->format('%a');
                                if ($daysRemaining == 0) {
                                    $daysRemaining = 1;
                                }
                            @endphp
                            <div
                                class="grid lg:grid-cols-2 gap-6 p-4 rounded-xl border border-slate-200 bg-white opacity-50">
                                <div>
                                    <p class="uppercase text-sm">Original Price</p>
                                    <p class="text-2xl font-bold">Harga <span class="text-red-600">Original</span></p>
                                    <p>Bermula Pada <span class="text-red-600 font-bold">{{ $originalstart }}</span></p>
                                </div>
                                <div class="flex items-center justify-center text-4xl font-bold pb-2 lg:pb-0">
                                    <p class="flex gap-2"><i class="fas fa-lock text-red-600"></i>RM 116</p>
                                </div>
                            </div>
                            <div
                                class="grid lg:grid-cols-2 gap-6 p-4 rounded-xl border border-slate-200 shadow bg-white">
                                <div>
                                    <p class="uppercase text-sm">Limited Promotion</p>
                                    <p class="text-2xl font-bold">{{ date('F') }} <span class="text-green-600">75%
                                            OFF</span>
                                    </p>
                                    <p><span class="text-green-600 font-bold">{{ $daysRemaining }} Hari</span> Lagi
                                        Sebelum Habis</p>
                                </div>
                                <div class="flex items-center justify-center text-4xl font-bold pb-2 lg:pb-0">
                                    <p class="flex gap-2 relative">
                                        <i class="fas fa-lock-open text-green-600"></i>RM 29<sub
                                            class="font-bold line-through text-red-700 text-sm absolute -top-4 right-0">RM
                                            116</sub>
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="grid lg:grid-cols-2 gap-6">
                        <a href="{{ route('purchase.checkout', $theme->code) }}">
                            <x-success-button class="w-full flex justify-center">
                                <i class="fas fa-shopping-cart mr-2"></i>Buy Now
                            </x-success-button>
                        </a>
                        <a href="{{ route('theme.preview', $theme->code) }}">
                            <x-primary-button class="w-full flex justify-center">
                                <i class="fas fa-envelope-open-text mr-2"></i>Preview
                            </x-primary-button>
                        </a>
                    </div>
                </div>
            </div>

            <div class=" bg-white dark:bg-gray-800 shadow lg:rounded-xl mb-12 overflow-hidden">
                <div class="px-6 py-4 bg-primary bg-opacity-20 text-cyan-700 font-semibold text-center">
                    Gunakan Discount Code <span class="bg-red-700 text-white rounded py-1 px-2">OFF75</span> Untuk
                    Dapatkan Potongan Harga
                    Sehingga 75%</div>
                @if(isset($theme->description) && $theme->description != '-')
                <div class="p-4 sm:p-8">
                    <h4 class="font-semibold text-lg mb-2">Description</h4>
                    <p class="">{{ $theme->description }}</p>
                </div>
                @endif
            </div>

            <h4 class="font-semibold text-lg mb-6 px-6 lg:px-0">Theme You Might Interested</h4>

            <div class="grid grid-cols-2 lg:grid-cols-4 gap-6 px-6 lg:px-0">
                @foreach ($themes as $theme)
                    <a href="{{ route('theme.show', $theme->code) }}" class="flex flex-col">
                        <img src="{{ url('/theme/' . $theme->code . '/sneak_view.jpg') }}"
                            class="w-full rounded-lg mb-2 shadow">
                        <p class="font-semibold text-lg">{{ $theme->name }}</p>
                        <p class="text-sm">{{ $theme->category }}</p>
                    </a>
                @endforeach
            </div>

        </div>
    </div>

</x-app-layout>
