<x-app-layout>

    <div class="pb-12 lg:py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8 flex flex-col">

            <div class="w-full h-60 bg-white rounded-lg shadow relative">
                <img src="{{ url('/storage/' . $vendor->cover_image) }}" alt="" class="w-full h-full object-cover">
                <div class="w-full absolute flex -bottom-16 px-6 lg:px-12 gap-6">
                    <div class="w-32 h-32 bg-white shadow rounded-lg">
                        <img src="{{ url('/storage/' . $vendor->logo_image) }}" alt=""
                            class="w-full h-full object-cover rounded-lg">
                    </div>
                    <div class="flex flex-col pt-20">
                        <h1 class="text-xl">{{ $vendor->name }}</h1>
                    </div>
                </div>
            </div>

            <style>
                td {
                    padding: .75rem;
                }
            </style>

            <div class="grid lg:grid-cols-2 mt-28 gap-12">

                <div class="flex flex-col">
                    <h1 class="font-bold text-xl pb-6 px-4 lg:px-0">Services</h1>
                    @if (isset($vendor->cardPrintServices))
                        <div class="bg-white rounded-lg shadow">
                            <div class="p-3 border-b mx-3 flex">
                                <p class="grow font-semibold">{{ $vendor->cardPrintServices->name }}</p>
                                <p><i class="fas fa-print"></i></p>
                            </div>
                            <table class="text-left w-full px-3">
                                <tbody>
                                    @foreach ($vendor->cardPrintServices->options as $option)
                                        <tr>
                                            <td class="px-6">{{ $option['data']['pieces'] }}<small> pcs</small></td>
                                            <td>RM {{ $option['data']['price'] }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @endif
                </div>

                <div>
                    <div class="bg-white rounded-lg shadow p-3 text-sm">
                        <table>
                            <tbody>
                                <tr>
                                    <td>Email</td>
                                    <td>{{ $vendor->email }}</td>
                                </tr>
                                <tr>
                                    <td>Phone</td>
                                    <td>{{ $vendor->phone_no }}</td>
                                </tr>
                                <tr>
                                    <td>WhatsApp</td>
                                    <td>{{ $vendor->whatsapp_no }}</td>
                                </tr>
                                <tr>
                                    <td>Address</td>
                                    <td>{{ $vendor->address }}</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>

            </div>

        </div>
    </div>



</x-app-layout>
