<?php

use App\Http\Controllers\HomeController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\CardController;
use App\Http\Controllers\PurchaseController;
use App\Http\Controllers\VendorController;
use App\Http\Controllers\Auth\SocialLoginController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', [HomeController::class, 'index'])->name('home.index');
Route::get('/themes', [HomeController::class, 'themes'])->name('theme.index');
Route::get('/theme/preview/{theme_code}', [HomeController::class, 'preview'])->name('theme.preview');
Route::get('/themes/{theme_code}', [HomeController::class, 'theme'])->name('theme.show');
Route::get('/contact', [HomeController::class, 'contact'])->name('home.contact');
Route::get('/about', [HomeController::class, 'about'])->name('home.about');

Route::get('/promo', [HomeController::class, 'promo'])->name('home.promo');
Route::get('/terms', [HomeController::class, 'terms'])->name('home.terms');
Route::get('/privacy', [HomeController::class, 'privacy'])->name('home.privacy');

Route::get('auth/{provider}', [SocialLoginController::class, 'redirectToProvider'])->name('social.login');
Route::get('auth/{provider}/callback', [SocialLoginController::class, 'handleProviderCallback'])->name('social.callback');

Route::get('/dashboard', function () {
    return redirect('/app');
})->middleware(['auth', 'verified'])->name('dashboard');

Route::get('/cards/{card}', [CardController::class, 'show'])->name('cards.show');
Route::get('/cards/{card}/print', [CardController::class, 'print'])->name('cards.print');
Route::get('/cards/{card}/metaverse', [CardController::class, 'metaverse'])->name('cards.metaverse');
Route::get('/cards/combo/{combo}', [CardController::class, 'combo'])->name('cards.combo');
Route::get('/cards/generic/{card}', [CardController::class, 'showGeneric'])->name('cards.show.generic');

Route::any('purchase/checkout/{theme_code}', [PurchaseController::class, 'checkout'])->name('purchase.checkout');
Route::any('purchase/discount-check', [PurchaseController::class, 'discountCheck'])->name('purchase.discount-check');
Route::any('purchase/post-checkout', [PurchaseController::class, 'postCheckout'])->name('purchase.post-checkout');
Route::any('purchase/thankyou', [PurchaseController::class, 'thankyou'])->name('purchase.thankyou');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');

    Route::prefix('vendors')->group(function () {
        Route::get('/{slug}', [VendorController::class, 'show'])->name('vendor.show');
    });
});



require __DIR__ . '/auth.php';
